/*------------------------------------------------------------------------------*
 * File Name: ImpWizFileTypes.c													*
 * Creation: 																	*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 

#include <Origin.h>
#include "IWfirst.h"


FileTypeList::FileTypeList()
{
}

void FileTypeList::Init(int nID, WndContainer& dlg)
{	
	GridListControl::Init(nID, dlg);		

	///Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION
	//SetupRowsCols(0, 1, 2, 1);	///Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL
	SetupRowsCols(1, 0, 1, 2);
	//m_flx.Cols = 2;
	//m_flx.Rows = 1;
	m_flx.Editable = flexEDKbd;
	//m_flx.Fixedcols = 0;
	m_flx.ScrollBars = flexScrollBarBoth;
	///END ADD_SOME_ACCESS_FUNCTION
	
	//m_flx.Row = 0; // first row is for column headings

	// File Spec
	//m_flx.Col = 0;
	//m_flx.ColWidth(0) = m_flx.ClientWidth / m_flx.Cols;
	//m_flx.Text = "File Spec.";
	SetColHeading(0, "File Spec.");

	// File Spec Name
	//m_flx.Col = 1;
	//m_flx.ColWidth(1) = m_flx.ClientWidth / m_flx.Cols;
	//m_flx.Text = "File Spec. Name";
	SetColHeading(1, "File Spec. Name");
	
	ResizeCols(2);
}

void FileTypeList::GetFileSpecNames(StringArray& saFileSpecNames)
{
	string str;
	for( int i = 1; i < m_flx.Rows; i++ )
	{
		m_flx.Row = i;
		str = m_flx.Text;
		saFileSpecNames.Add(str);
	}
}

void FileTypeList::UpdateFromExtList(LPCSTR lpcstrFileSpecList)
{
	m_flx.Rows = 1; // only the column headings
	m_flx.Col = 0; // first column holds file spec

	StringArray saFileSpecs;
	string strFileSpecs(lpcstrFileSpecList);
	strFileSpecs.GetTokens(saFileSpecs, ';');

	for( int i = 0; i < saFileSpecs.GetSize(); i++ )
	{
		m_flx.Rows = i + 2; // +2 = 1(col headings)+1(1 based)
		m_flx.Row = i + 1; // +1 to skip col headings
		m_flx.Text = saFileSpecs[i];
	}
}

void FileTypeList::UpdateFromTree(StringArray saFileSpecNames)
{
	m_flx.Col = 1; // 2nd column holds file spec names
	m_flx.Row = 1; // start at row after column headings

	for( int i = 0; i < saFileSpecNames.GetSize(); i++ )
	{
		m_flx.Row = i + 1; // +1 to skip col headings
		m_flx.Text = saFileSpecNames[i];
	}
}


///Danice 12/25/03 v7.5788 NOTUSE_SHOW
DWORD ImpWizFileTypesPage::OnShowStatus(DWORD InternalStatus)
{
	return PSS_Ignore;
}
///END NOTUSE_SHOW

BOOL ImpWizFileTypesPage::OnInit_FileTypes()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_FILE_TYPES
	
	///Danice PAGE_INIT_ONCE
	if(!ImpWizardPage::Init())
		return FALSE;
	///END PAGE_INIT_ONCE

	///Jason 12/14/03 v7.5781 MOVED_INITIAL_FUNCTION
	m_editGroupName = GetItem(IDC_FILE_TYPES_GROUP_NAME);
	//m_ctrlGrid = GetItem(IDC_FILE_TYPES_WILDCARDS_GRID);///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
	///End MOVED_INITIAL_FUNCTION
	FileTypes_SetupGrid();
	return TRUE;
}

BOOL ImpWizFileTypesPage::OnActive_FileTypes()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_FILE_TYPES
	return FileTypes_UpdateData();
}

BOOL ImpWizFileTypesPage::OnKillActive_FileTypes()	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	ON_PAGE_CHECK_FILE_TYPES
	return FileTypes_UpdateData(FALSE);
}

BOOL ImpWizFileTypesPage::OnBeforeEditTypes_FileTypes(Control ctrl, int iRow, int iCol, BOOL *pCancel)	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
{
	if( iCol == 0 )
		*pCancel = true; // do not allow editing first column
	return true;
}

BOOL ImpWizFileTypesPage::FileTypes_UpdateData(BOOL bDataToDlg) //=TRUE)
{
	//Edit editGroupName = ImportWizDlg.GetItem(IDC_FILE_TYPES_GROUP_NAME, IDD_IW_FILETYPES);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_FILE_TYPES

	if( bDataToDlg )
	{
		fuGetFilesOfTypeGroupName(s_trFilter, m_editGroupName.Text);
		FileTypes_UpdateGridFromTree();
	}
	else // dialog to data
	{
		fuSetFilesOfTypeGroupName(s_trFilter, m_editGroupName.Text);
		FileTypes_UpdateTreeFromGrid();
	}

	return TRUE;	
}

void ImpWizFileTypesPage::FileTypes_UpdateTreeFromGrid()
{
	///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
	/*
	string str;
	
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_FILE_TYPES_WILDCARDS_GRID, IDD_IW_FILETYPES);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_FILE_TYPES
	Object objGrid = m_ctrlGrid.GetActiveXControl();
	for( int i = 1; i < objGrid.Rows; i++ )
	{
		objGrid.Row = i;
		str = objGrid.Text;
		saFileSpecNames.Add(str);
	}
	*/
	StringArray saFileSpecNames;
	m_ctrlFileTypeGrid.GetFileSpecNames(saFileSpecNames);
	///End REMOVE_FILETYPELIST_TO_CLASS
	fuSetFilesOfType(s_trFilter, saFileSpecNames);
	
}

void ImpWizFileTypesPage::FileTypes_UpdateGridFromTree()
{
	///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_FILE_TYPES_WILDCARDS_GRID, IDD_IW_FILETYPES);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_FILE_TYPES
	if( !m_ctrlGrid )
		return;

	Object objGrid = m_ctrlGrid.GetActiveXControl();
	if( !objGrid )
		return;

	objGrid.Rows = 1;

	string str;
	fuGetFileSpec(s_trFilter, str);
	if( str.IsEmpty() )
		return;
	FileTypes_UpdateGridFromExtList(str);

	StringArray saFileSpecNames;
	fuGetFilesOfType(s_trFilter, saFileSpecNames);

	objGrid.Col = 1; // 2nd column holds file spec names
	objGrid.Row = 1; // start at row after column headings

	for( int i = 0; i < saFileSpecNames.GetSize(); i++ )
	{
		objGrid.Row = i + 1; // +1 to skip col headings
		objGrid.Text = saFileSpecNames[i];
	}
	*/
	string str;
	fuGetFileSpec(s_trFilter, str);
	if( str.IsEmpty() )
		return;
	FileTypes_UpdateGridFromExtList(str);
	
	StringArray saFileSpecNames;
	fuGetFilesOfType(s_trFilter, saFileSpecNames);
	
	m_ctrlFileTypeGrid.UpdateFromTree(saFileSpecNames);
	///End REMOVE_FILETYPELIST_TO_CLASS
}

void ImpWizFileTypesPage::FileTypes_UpdateGridFromExtList(LPCSTR lpcstrFileSpecList)
{
	///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_FILE_TYPES_WILDCARDS_GRID, IDD_IW_FILETYPES);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_FILE_TYPES
	if( !m_ctrlGrid )
		return;

	Object objGrid = m_ctrlGrid.GetActiveXControl();
	if( !objGrid )
		return;

	objGrid.Rows = 1; // only the column headings
	objGrid.Col = 0; // first column holds file spec

	StringArray saFileSpecs;
	string strFileSpecs(lpcstrFileSpecList);
	strFileSpecs.GetTokens(saFileSpecs, ';');

	for( int i = 0; i < saFileSpecs.GetSize(); i++ )
	{
		objGrid.Rows = i + 2; // +2 = 1(col headings)+1(1 based)
		objGrid.Row = i + 1; // +1 to skip col headings
		objGrid.Text = saFileSpecs[i];
	}
	*/
	m_ctrlFileTypeGrid.UpdateFromExtList(lpcstrFileSpecList);
	///End REMOVE_FILETYPELIST_TO_CLASS
}

void ImpWizFileTypesPage::FileTypes_SetupGrid()
{
	///Iris 02/12/04 REMOVE_FILETYPELIST_TO_CLASS
	/*
	//Control ctrlGrid = ImportWizDlg.GetItem(IDC_FILE_TYPES_WILDCARDS_GRID, IDD_IW_FILETYPES);	///Jason 12/14/03 v7.5781 MOVE_TO_ON_INIT_FILE_TYPES
	if( !m_ctrlGrid )
		return;

	Object objGrid = m_ctrlGrid.GetActiveXControl();
	if( !objGrid )
		return;

	objGrid.Cols = 2;
	objGrid.Rows = 1;
	objGrid.Editable = 1;
	objGrid.Fixedcols = 0;
	objGrid.ScrollBars = 3;

	objGrid.Row = 0; // first row is for column headings

	// File Spec
	objGrid.Col = 0;
	objGrid.ColWidth(0) = objGrid.ClientWidth / objGrid.Cols;
	objGrid.Text = "File Spec.";

	// File Spec Name
	objGrid.Col = 1;
	objGrid.ColWidth(1) = objGrid.ClientWidth / objGrid.Cols;
	objGrid.Text = "File Spec. Name";
	*/
	m_ctrlFileTypeGrid.Init(IDC_FILE_TYPES_WILDCARDS_GRID, *this);
	///End REMOVE_FILETYPELIST_TO_CLASS
}	

